/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.pojo;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import javassist.CannotCompileException;
import javassist.NotFoundException;
import org.dom4j.Document;
import org.hibernatespatial.pojo.ClassInfo;
import org.hibernatespatial.pojo.ClassInfoMap;
import org.hibernatespatial.pojo.MappingsGenerator;
import org.hibernatespatial.pojo.PKeyNotFoundException;
import org.hibernatespatial.pojo.POJOGenerator;
import org.hibernatespatial.pojo.TableMetaData;
import org.hibernatespatial.pojo.TableNotFoundException;
import org.hibernatespatial.pojo.TypeMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POJOUtility {
    private final Connection conn;
    private final ClassInfoMap classInfoMap = new ClassInfoMap();
    private final POJOGenerator pojoGenerator;
    private final MappingsGenerator mappingGenerator;

    public POJOUtility(Connection conn, String packageName, TypeMapper typeMapper) {
        this.conn = conn;
        this.pojoGenerator = new POJOGenerator(packageName, typeMapper);
        this.mappingGenerator = new MappingsGenerator(packageName);
    }

    public Document map(Collection<String> tableNames) throws SQLException, TableNotFoundException, CannotCompileException, NotFoundException {
        ArrayList<TableMetaData> tmds = new ArrayList<TableMetaData>();
        DatabaseMetaData dmd = this.conn.getMetaData();
        for (String tableName : tableNames) {
            ClassInfo pojoInfo = this.classInfoMap.getClassInfo(tableName);
            if (pojoInfo != null) continue;
            TableMetaData tmd = TableMetaData.load(tableName, dmd);
            tmds.add(tmd);
            pojoInfo = this.pojoGenerator.createClassInfo(tmd);
            this.classInfoMap.add(tmd.getName(), pojoInfo);
        }
        try {
            this.mappingGenerator.load(tmds, this.classInfoMap);
        }
        catch (PKeyNotFoundException e) {
            throw new RuntimeException(e);
        }
        return this.mappingGenerator.getMappingsDoc();
    }

    public ClassInfoMap getClassInfoMap() {
        return this.classInfoMap;
    }

    private boolean isJavaIdentifier(String in) {
        int n = in.length();
        if (n == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(in.charAt(0))) {
            return false;
        }
        for (int i = 1; i < n; ++i) {
            if (Character.isJavaIdentifierPart(in.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

