/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.pojo;

import java.util.HashMap;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import org.hibernatespatial.pojo.AttributeInfo;
import org.hibernatespatial.pojo.ClassInfo;
import org.hibernatespatial.pojo.ColumnMetaData;
import org.hibernatespatial.pojo.NamingStrategy;
import org.hibernatespatial.pojo.SimpleNamingStrategy;
import org.hibernatespatial.pojo.TableMetaData;
import org.hibernatespatial.pojo.TypeMapper;

public class POJOGenerator {
    private final ClassPool pool = ClassPool.getDefault();
    private NamingStrategy naming = new SimpleNamingStrategy();
    private final String packageName;
    private final TypeMapper typeMapper;

    public POJOGenerator(String packageName, TypeMapper typeMapper) {
        this.packageName = packageName;
        this.typeMapper = typeMapper;
    }

    public void setNamingStrategy(NamingStrategy strategy) {
        this.naming = strategy;
    }

    public ClassInfo createClassInfo(TableMetaData tmd) throws CannotCompileException, NotFoundException {
        String classname = this.packageName + "." + this.naming.createClassName(tmd.getName());
        CtClass pojo = this.pool.makeClass(classname);
        ClassInfo classInfo = new ClassInfo(tmd.getName(), classname);
        HashMap<String, String> fldGetterMap = new HashMap<String, String>();
        for (ColumnMetaData cmd : tmd.getColumns()) {
            CtField field = this.createField(cmd, pojo);
            CtMethod getter = this.createGetterMethod(field);
            CtMethod setter = this.createSetterMethod(field);
            pojo.addField(field);
            pojo.addMethod(getter);
            pojo.addMethod(setter);
            AttributeInfo ai = new AttributeInfo();
            ai.setColumnName(cmd.getName());
            ai.setFieldName(field.getName());
            ai.setHibernateType(this.typeMapper.getHibernateType(cmd.getDbType(), cmd.getJavaType()));
            ai.setIdentifier(cmd.isPkey());
            classInfo.addAttribute(ai);
            fldGetterMap.put(field.getName(), getter.getName());
        }
        classInfo.setPOJOClass(pojo.toClass());
        return classInfo;
    }

    public String getPackageName() {
        return this.packageName;
    }

    private CtMethod createGetterMethod(CtField field) throws CannotCompileException {
        String fn = field.getName();
        return CtNewMethod.getter((String)this.naming.createGetterName(fn), (CtField)field);
    }

    private CtMethod createSetterMethod(CtField field) throws CannotCompileException {
        String fn = field.getName();
        return CtNewMethod.setter((String)this.naming.createSetterName(fn), (CtField)field);
    }

    private CtField createField(ColumnMetaData cmd, CtClass declaring) throws CannotCompileException {
        CtClass type = this.typeMapper.getCtClass(cmd.getDbType(), cmd.getJavaType());
        if (type == null) {
            throw new RuntimeException("Failed to find type for column " + cmd.getName());
        }
        CtField f = new CtField(type, this.naming.createPropertyName(cmd.getName()), declaring);
        return f;
    }
}

